
// apple.h

#ifndef EMUAPPLE_H
#define EMUAPPLE_H 

#include "Emu6502.h"

const int HW_LO  = 0xC000;
const int ROM_LO = 0xD000;
const int GR_TXMODE	= 1;
const int GR_MIXMODE	= 2;
const int GR_PAGE1	= 4;
const int GR_HIRES	= 8;
const int DBG_CPU	= 1;
const int DBG_RDMEM	= 2;
const int DBG_WRMEM	= 4;
const int DBG_KBD	= 0x10000;
const int DBG_GR		= 0x50000;
const int DBG_SLOTS	= 0x100;

const int DIRTY_SHIFT = 7;

class TAppleII;

class TApplePeripheral
{
protected:
	TAppleII *apple;
public:
	TApplePeripheral(TAppleII *apple);
	virtual int doIO(int address, int value);
	virtual int doHighIO(int address, int value);
};

class TNullPeripheral : public TApplePeripheral 
{ 
public:
	TNullPeripheral(TAppleII* apple) : TApplePeripheral(apple) { }
};

struct TAppleIIHardwareState
{
	int grswitch;
	int kbdlatch;
	int soundstate;
	// language card switches
	boolean auxRAMselected;
	int		auxRAMbank;
	boolean writeinhibit;
};

struct TAppleIIRunProfile
{
	int kbd_poll_count;
};

class TAppleIISoundListener
{
public:
	virtual void soundChanged(int clock, int newstate) = 0;
};

class TAppleII : public T6502Emulation
{
private:
	TAppleIIHardwareState hwstate;
	TAppleIIRunProfile profile;
	TAppleIISoundListener* sndlistener;
public:
	TAppleII();

	virtual ~TAppleII();
	virtual int readMemory(int address);
	virtual void writeMemory(int address, int value);
	virtual byte* getMemoryBase();
	virtual void hardReset();

	byte* getROMBase() { return mem + 0x14000; }
	int getGrswitch() { return hwstate.grswitch; }
	int getKbdlatch() { return hwstate.kbdlatch; }
	int getSoundstate() { return hwstate.soundstate; }
	void setSoundListener(TAppleIISoundListener* aSndlistener) { sndlistener = aSndlistener; }
	void setDirty(int address, boolean value) { dirty[address>>DIRTY_SHIFT] = value; }
	void setRangeDirty(int startAddress, int endAddress, boolean value);
	int isDirty(int address) { return dirty[address>>DIRTY_SHIFT]; }
	int isRangeDirty(int startAddress, int endAddress);
	int noise();
	int doIO(int address, int value);
	void clearStrobe();
	void pressKey(int key);
	TApplePeripheral *getPeripheral(int index);
	void setPeripheral(int index, TApplePeripheral *peripheral);
	void execute(int cycles);
private:

	int doDebug(int mask);
	int doLanguageCardIO(int address, int value);
	void setupMemory();
	void setupLCMemory();

	TApplePeripheral *slots[8];

	boolean dirty[0x10000>>DIRTY_SHIFT];

	// value to add when reading & writing each of these banks
	// bank 1 is D000-FFFF, bank 2 is D000-DFFF
	int bank1rdoffset, bank2rdoffset, bank1wroffset, bank2wroffset;
	void computeBankOffsets();
};

#endif // EMUAPPLE_H
